--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--
rollout DYNpreferences ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCskyMapPathChanged      = false
  local LOCcountryRootPathChanged = false
  local LOCprojectKitPathChanged  = false
  local LOCprivateKitPathChanged  = false
  local LOCcountryRootPath
  local LOCskyMapPath
  local LOCprivateKitPath = ""
  local LOCprojectKitPath = ""

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNmoveControls FUNtabIndex =
  (
    DYNpreferences.dnTabCtrl.selectedIndex = FUNtabIndex-1

    if FUNtabIndex == 1 then
    (
      DYNpreferences.GBPREmatGeneral.pos.x    = -2243
      DYNpreferences.GBPREDynSurfaces.pos.x   = -2243
      DYNpreferences.GBPREimportGen.pos.x     = -2243
      DYNpreferences.GBPREimportC3D.pos.x     = -2243
      DYNpreferences.GBPREcountryKit.pos.x    = -2243
      DYNpreferences.LBPREcountryKit.pos.x    = -2227
      DYNpreferences.BUPREcountryKit.pos.x    = -2327
      DYNpreferences.GBPREprojectKit.pos.x    = -2243
      DYNpreferences.RBPREprojectKit.pos.x    = -2227
      DYNpreferences.LBPREprojectKit.pos.x    = -2227
      DYNpreferences.BUPREprojectKit.pos.x    = -2327
      DYNpreferences.GBPREprivateKit.pos.x    = -2243
      DYNpreferences.LBPREprivateKit.pos.x    = -2227
      DYNpreferences.CBPREprivateKit.pos.x    = -2227
      DYNpreferences.CBPREc3dOverHang.pos.x   = -2227
      DYNpreferences.CBPREhideDiagonals.pos.x = -2227
      DYNpreferences.BUPREprivateKit.pos.x    = -2327
      DYNpreferences.GBPREskyMapLoc.pos.x     = -2243
      DYNpreferences.GBPREanimUnits.pos.x     = -2243
      DYNpreferences.LBPREskyMapLoc.pos.x     = -2227
      DYNpreferences.BUPREskyMapLoc.pos.x     = -2327
      DYNpreferences.LBPREcountry.pos.x       = -2198
      DYNpreferences.DDPREcountry.pos.x       = -2278
      DYNpreferences.DDPREdistUnit.pos.x      = -2243
      DYNpreferences.LBPREdistUnit.pos.x      = -2243
      DYNpreferences.DDPREtimeUnit.pos.x      = -2205
      DYNpreferences.LBPREtimeUnit.pos.x      = -2205
      DYNpreferences.SPPREexplorerWidth.pos.x = 475
      DYNpreferences.LBPREexplorerWidth.pos.x = 263
      DYNpreferences.CBPREshowIcons.pos.x     = 18
      DYNpreferences.CBPREdockExplorer.pos.x  = 18
      DYNpreferences.CBPREcommandPanel.pos.x  = 18
      DYNpreferences.CBPREresetMaxMenu.pos.x  = 18
      DYNpreferences.CBPREdisableGrid.pos.x   = 18
      DYNpreferences.CBPRErotateWheels.pos.x  = 263
      DYNpreferences.LBPREshowIcons.pos.x     = 34
      DYNpreferences.LBPREdockExplorer.pos.x  = 34
      DYNpreferences.LBPREcommandPanel.pos.x  = 34
      DYNpreferences.LBPREresetMaxMenu.pos.x  = 34
      DYNpreferences.LBPREdisableGrid.pos.x   = 34
      DYNpreferences.LBPRErotateWheels.pos.x  = 279
      DYNpreferences.CBPREretainOPSmat.pos.x  = -2018
      DYNpreferences.CBPREautoStart.pos.x     = 18
      DYNpreferences.CBPREchainageLoop.pos.x  = 263
      DYNpreferences.CBPREallowMultMarks.pos.x= 263
      DYNpreferences.CBPREallowMultRails.pos.x= 263
      DYNpreferences.LBPREautoStart.pos.x     = 34
      DYNpreferences.LBPREchainageLoop.pos.x   = 279
      DYNpreferences.LBPREallowMultMarks.pos.x= 279
      DYNpreferences.LBPREallowMultRails.pos.x= 279
      DYNpreferences.GBPREspacer01.pos.x      = 254
      DYNpreferences.LBPREframeRate.pos.x     = 263
      DYNpreferences.SPPREframeRate.pos.x     = 475
      DYNpreferences.LBPREmarkerSize.pos.x    = 263
      DYNpreferences.SPPREmarkerSize.pos.x    = 475
      DYNpreferences.LBPREungpMatChan.pos.x   = -2263
      DYNpreferences.SPPREungpMatChan.pos.x   = -2475
      DYNpreferences.LBPREfaceSmoothing.pos.x = -2263
      DYNpreferences.SPPREfaceSmoothing.pos.x = -2475
      DYNpreferences.SPPREmatIDlimit.pos.x    = -2475
      DYNpreferences.LBPREmatIDlimit.pos.x    = -2475
      DYNpreferences.LBPREtreeVariation.pos.x = 263
      DYNpreferences.SPPREtreeVariation.pos.x = 475
      DYNpreferences.CODYNcolor1.pos.x = -2243
      DYNpreferences.CODYNcolor2.pos.x = -2243
      DYNpreferences.CODYNcolor3.pos.x = -2243
      DYNpreferences.CODYNcolor4.pos.x = -2243
      DYNpreferences.CODYNcolor5.pos.x = -2243
      DYNpreferences.LBDYNcolor1.pos.x = -2660
      DYNpreferences.LBDYNcolor2.pos.x = -2660
      DYNpreferences.LBDYNcolor3.pos.x = -2660
      DYNpreferences.LBDYNcolor4.pos.x = -2660
      DYNpreferences.LBDYNcolor5.pos.x = -2660

      DYNpreferences.CBPREdockExplorer.enabled = true
    )
    if FUNtabIndex == 2 then
    (
      DYNpreferences.GBPREmatGeneral.pos.x    = -2243
      DYNpreferences.GBPREDynSurfaces.pos.x   = -2243
      DYNpreferences.GBPREimportGen.pos.x     = -2243
      DYNpreferences.GBPREimportC3D.pos.x     = -2243
      DYNpreferences.GBPREcountryKit.pos.x    = -2243
      DYNpreferences.LBPREcountryKit.pos.x    = -2227
      DYNpreferences.BUPREcountryKit.pos.x    = -2327
      DYNpreferences.GBPREprojectKit.pos.x    = -2243
      DYNpreferences.RBPREprojectKit.pos.x    = -2227
      DYNpreferences.LBPREprojectKit.pos.x    = -2227
      DYNpreferences.BUPREprojectKit.pos.x    = -2327
      DYNpreferences.GBPREprivateKit.pos.x    = -2243
      DYNpreferences.LBPREprivateKit.pos.x    = -2227
      DYNpreferences.CBPREprivateKit.pos.x    = -2227
      DYNpreferences.CBPREc3dOverHang.pos.x   = -2227
      DYNpreferences.CBPREhideDiagonals.pos.x = -2227
      DYNpreferences.BUPREprivateKit.pos.x    = -2327
      DYNpreferences.GBPREskyMapLoc.pos.x     = 18
      DYNpreferences.GBPREanimUnits.pos.x     = 18
      DYNpreferences.LBPREskyMapLoc.pos.x     = 27
      DYNpreferences.BUPREskyMapLoc.pos.x     = 457
      DYNpreferences.LBPREcountry.pos.x       = -2198
      DYNpreferences.DDPREcountry.pos.x       = -2278
      DYNpreferences.DDPREdistUnit.pos.x      = 28
      DYNpreferences.LBPREdistUnit.pos.x      = 28
      DYNpreferences.DDPREtimeUnit.pos.x      = 28
      DYNpreferences.LBPREtimeUnit.pos.x      = 28
      DYNpreferences.SPPREexplorerWidth.pos.x = -2345
      DYNpreferences.LBPREexplorerWidth.pos.x = -2198
      DYNpreferences.CBPREshowIcons.pos.x     = -2243
      DYNpreferences.CBPREdockExplorer.pos.x  = -2243
      DYNpreferences.CBPREcommandPanel.pos.x  = -2243
      DYNpreferences.CBPREresetMaxMenu.pos.x  = -2243
      DYNpreferences.CBPREdisableGrid.pos.x   = -2243
      DYNpreferences.CBPRErotateWheels.pos.x  = -2243
      DYNpreferences.LBPREshowIcons.pos.x     = -2243
      DYNpreferences.LBPREdockExplorer.pos.x  = -2243
      DYNpreferences.LBPREcommandPanel.pos.x  = -2243
      DYNpreferences.LBPREresetMaxMenu.pos.x  = -2243
      DYNpreferences.LBPREdisableGrid.pos.x   = -2243
      DYNpreferences.LBPRErotateWheels.pos.x  = -2243
      DYNpreferences.CBPREretainOPSmat.pos.x  = -2018
      DYNpreferences.CBPREautoStart.pos.x     = -2198
      DYNpreferences.CBPREchainageLoop.pos.x  = -2198
      DYNpreferences.CBPREallowMultMarks.pos.x= -2198
      DYNpreferences.CBPREallowMultRails.pos.x= -2198
      DYNpreferences.LBPREautoStart.pos.x      = -2198
      DYNpreferences.LBPREchainageLoop.pos.x  = -2198
      DYNpreferences.LBPREallowMultMarks.pos.x= -2198
      DYNpreferences.LBPREallowMultRails.pos.x= -2198
      DYNpreferences.GBPREspacer01.pos.x      = -2189
      DYNpreferences.LBPREframeRate.pos.x     = -2198
      DYNpreferences.SPPREframeRate.pos.x     = -2345
      DYNpreferences.LBPREmarkerSize.pos.x    = -2198
      DYNpreferences.SPPREmarkerSize.pos.x    = -2345
      DYNpreferences.LBPREungpMatChan.pos.x   = -2198
      DYNpreferences.SPPREungpMatChan.pos.x   = -2345
      DYNpreferences.LBPREfaceSmoothing.pos.x = -2263
      DYNpreferences.SPPREfaceSmoothing.pos.x = -2475
      DYNpreferences.SPPREmatIDlimit.pos.x    = -2475
      DYNpreferences.LBPREmatIDlimit.pos.x    = -2475
      DYNpreferences.LBPREtreeVariation.pos.x = -2198
      DYNpreferences.SPPREtreeVariation.pos.x = -2345
      DYNpreferences.CODYNcolor1.pos.x = -2243
      DYNpreferences.CODYNcolor2.pos.x = -2243
      DYNpreferences.CODYNcolor3.pos.x = -2243
      DYNpreferences.CODYNcolor4.pos.x = -2243
      DYNpreferences.CODYNcolor5.pos.x = -2243
      DYNpreferences.LBDYNcolor1.pos.x = -2660
      DYNpreferences.LBDYNcolor2.pos.x = -2660
      DYNpreferences.LBDYNcolor3.pos.x = -2660
      DYNpreferences.LBDYNcolor4.pos.x = -2660
      DYNpreferences.LBDYNcolor5.pos.x = -2660
    )
    if FUNtabIndex == 3 then
    (
      DYNpreferences.GBPREmatGeneral.pos.x    = -2243
      DYNpreferences.GBPREDynSurfaces.pos.x   = -2243
      DYNpreferences.GBPREimportGen.pos.x     = -2243
      DYNpreferences.GBPREimportC3D.pos.x     = -2243
      DYNpreferences.GBPREcountryKit.pos.x    = -2243
      DYNpreferences.LBPREcountryKit.pos.x    = -2227
      DYNpreferences.BUPREcountryKit.pos.x    = -2327
      DYNpreferences.GBPREprojectKit.pos.x    = -2243
      DYNpreferences.RBPREprojectKit.pos.x    = -2227
      DYNpreferences.LBPREprojectKit.pos.x    = -2227
      DYNpreferences.BUPREprojectKit.pos.x    = -2327
      DYNpreferences.GBPREprivateKit.pos.x    = -2243
      DYNpreferences.LBPREprivateKit.pos.x    = -2227
      DYNpreferences.CBPREprivateKit.pos.x    = -2227
      DYNpreferences.CBPREc3dOverHang.pos.x   = -2227
      DYNpreferences.CBPREhideDiagonals.pos.x = -2227
      DYNpreferences.BUPREprivateKit.pos.x    = -2327
      DYNpreferences.GBPREskyMapLoc.pos.x     = -2243
      DYNpreferences.GBPREanimUnits.pos.x     = -2243
      DYNpreferences.LBPREskyMapLoc.pos.x     = -2227
      DYNpreferences.BUPREskyMapLoc.pos.x     = -2327
      DYNpreferences.LBPREcountry.pos.x       = -2198
      DYNpreferences.DDPREcountry.pos.x       = -2278
      DYNpreferences.DDPREdistUnit.pos.x      = -2243
      DYNpreferences.LBPREdistUnit.pos.x      = -2243
      DYNpreferences.DDPREtimeUnit.pos.x      = -2205
      DYNpreferences.LBPREtimeUnit.pos.x      = -2205
      DYNpreferences.SPPREexplorerWidth.pos.x = -2345
      DYNpreferences.LBPREexplorerWidth.pos.x = -2198
      DYNpreferences.CBPREshowIcons.pos.x     = -2243
      DYNpreferences.CBPREdockExplorer.pos.x  = -2243
      DYNpreferences.CBPREcommandPanel.pos.x  = -2243
      DYNpreferences.CBPREresetMaxMenu.pos.x  = -2243
      DYNpreferences.CBPREdisableGrid.pos.x   = -2243
      DYNpreferences.CBPRErotateWheels.pos.x  = -2243
      DYNpreferences.LBPREshowIcons.pos.x     = -2243
      DYNpreferences.LBPREdockExplorer.pos.x  = -2243
      DYNpreferences.LBPREcommandPanel.pos.x  = -2243
      DYNpreferences.LBPREresetMaxMenu.pos.x  = -2243
      DYNpreferences.LBPREdisableGrid.pos.x   = -2243
      DYNpreferences.LBPRErotateWheels.pos.x  = -2243
      DYNpreferences.CBPREretainOPSmat.pos.x  = -2018
      DYNpreferences.CBPREautoStart.pos.x     = -2198
      DYNpreferences.CBPREchainageLoop.pos.x  = -2198
      DYNpreferences.CBPREallowMultMarks.pos.x= -2198
      DYNpreferences.CBPREallowMultRails.pos.x= -2198
      DYNpreferences.LBPREautoStart.pos.x      = -2198
      DYNpreferences.LBPREchainageLoop.pos.x  = -2198
      DYNpreferences.LBPREallowMultMarks.pos.x= -2198
      DYNpreferences.LBPREallowMultRails.pos.x= -2198
      DYNpreferences.GBPREspacer01.pos.x      = -2189
      DYNpreferences.LBPREframeRate.pos.x     = -2198
      DYNpreferences.SPPREframeRate.pos.x     = -2345
      DYNpreferences.LBPREmarkerSize.pos.x    = -2198
      DYNpreferences.SPPREmarkerSize.pos.x    = -2345
      DYNpreferences.LBPREungpMatChan.pos.x   = -2198
      DYNpreferences.SPPREungpMatChan.pos.x   = -2345
      DYNpreferences.LBPREfaceSmoothing.pos.x = -2263
      DYNpreferences.SPPREfaceSmoothing.pos.x = -2475
      DYNpreferences.SPPREmatIDlimit.pos.x    = -2475
      DYNpreferences.LBPREmatIDlimit.pos.x    = -2475
      DYNpreferences.LBPREtreeVariation.pos.x = -2198
      DYNpreferences.SPPREtreeVariation.pos.x = -2345
      DYNpreferences.CODYNcolor1.pos.x = 18
      DYNpreferences.CODYNcolor2.pos.x = 18
      DYNpreferences.CODYNcolor3.pos.x = 18
      DYNpreferences.CODYNcolor4.pos.x = 18
      DYNpreferences.CODYNcolor5.pos.x = 18
      DYNpreferences.LBDYNcolor1.pos.x = 60
      DYNpreferences.LBDYNcolor2.pos.x = 60
      DYNpreferences.LBDYNcolor3.pos.x = 60
      DYNpreferences.LBDYNcolor4.pos.x = 60
      DYNpreferences.LBDYNcolor5.pos.x = 60
    )
    if FUNtabIndex == 4 then
    (
      DYNpreferences.GBPREmatGeneral.pos.x    = -2243
      DYNpreferences.GBPREDynSurfaces.pos.x   = -2243
      DYNpreferences.GBPREimportGen.pos.x     = -2243
      DYNpreferences.GBPREimportC3D.pos.x     = -2243
      DYNpreferences.GBPREcountryKit.pos.x    = 18
      DYNpreferences.LBPREcountryKit.pos.x    = 27
      DYNpreferences.BUPREcountryKit.pos.x    = 457
      DYNpreferences.GBPREprojectKit.pos.x    = 18
      DYNpreferences.RBPREprojectKit.pos.x    = 27
      DYNpreferences.LBPREprojectKit.pos.x    = 27
      DYNpreferences.BUPREprojectKit.pos.x    = 457
      DYNpreferences.GBPREprivateKit.pos.x    = 18
      DYNpreferences.LBPREprivateKit.pos.x    = 27
      DYNpreferences.CBPREprivateKit.pos.x    = 27
      DYNpreferences.CBPREc3dOverHang.pos.x   = -2227
      DYNpreferences.CBPREhideDiagonals.pos.x = -2227
      DYNpreferences.BUPREprivateKit.pos.x    = 457
      DYNpreferences.GBPREskyMapLoc.pos.x     = -2243
      DYNpreferences.GBPREanimUnits.pos.x     = -2243
      DYNpreferences.LBPREskyMapLoc.pos.x     = -2227
      DYNpreferences.BUPREskyMapLoc.pos.x     = -2327
      DYNpreferences.LBPREcountry.pos.x       = 27
      DYNpreferences.DDPREcountry.pos.x       = 278
      DYNpreferences.DDPREdistUnit.pos.x      = -2243
      DYNpreferences.LBPREdistUnit.pos.x      = -2243
      DYNpreferences.DDPREtimeUnit.pos.x      = -2205
      DYNpreferences.LBPREtimeUnit.pos.x      = -2205
      DYNpreferences.SPPREexplorerWidth.pos.x = -2345
      DYNpreferences.LBPREexplorerWidth.pos.x = -2198
      DYNpreferences.CBPREshowIcons.pos.x     = -2243
      DYNpreferences.CBPREdockExplorer.pos.x  = -2243
      DYNpreferences.CBPREcommandPanel.pos.x  = -2243
      DYNpreferences.CBPREresetMaxMenu.pos.x  = -2243
      DYNpreferences.CBPREdisableGrid.pos.x   = -2243
      DYNpreferences.CBPRErotateWheels.pos.x  = -2243
      DYNpreferences.LBPREshowIcons.pos.x     = -2243
      DYNpreferences.LBPREdockExplorer.pos.x  = -2243
      DYNpreferences.LBPREcommandPanel.pos.x  = -2243
      DYNpreferences.LBPREresetMaxMenu.pos.x  = -2243
      DYNpreferences.LBPREdisableGrid.pos.x   = -2243
      DYNpreferences.LBPRErotateWheels.pos.x  = -2243
      DYNpreferences.CBPREretainOPSmat.pos.x  = -2018
      DYNpreferences.CBPREautoStart.pos.x     = -2198
      DYNpreferences.CBPREchainageLoop.pos.x  = -2198
      DYNpreferences.CBPREallowMultMarks.pos.x= -2198
      DYNpreferences.CBPREallowMultRails.pos.x= -2198
      DYNpreferences.LBPREautoStart.pos.x      = -2198
      DYNpreferences.LBPREchainageLoop.pos.x  = -2198
      DYNpreferences.LBPREallowMultMarks.pos.x= -2198
      DYNpreferences.LBPREallowMultRails.pos.x= -2198
      DYNpreferences.GBPREspacer01.pos.x      = -2189
      DYNpreferences.LBPREframeRate.pos.x     = -2198
      DYNpreferences.SPPREframeRate.pos.x     = -2345
      DYNpreferences.LBPREmarkerSize.pos.x    = -2198
      DYNpreferences.SPPREmarkerSize.pos.x    = -2345
      DYNpreferences.LBPREungpMatChan.pos.x   = -2198
      DYNpreferences.SPPREungpMatChan.pos.x   = -2345
      DYNpreferences.LBPREfaceSmoothing.pos.x = -2263
      DYNpreferences.SPPREfaceSmoothing.pos.x = -2475
      DYNpreferences.SPPREmatIDlimit.pos.x    = -2475
      DYNpreferences.LBPREmatIDlimit.pos.x    = -2475
      DYNpreferences.LBPREtreeVariation.pos.x = -2198
      DYNpreferences.SPPREtreeVariation.pos.x = -2345
      DYNpreferences.CODYNcolor1.pos.x = -2243
      DYNpreferences.CODYNcolor2.pos.x = -2243
      DYNpreferences.CODYNcolor3.pos.x = -2243
      DYNpreferences.CODYNcolor4.pos.x = -2243
      DYNpreferences.CODYNcolor5.pos.x = -2243
      DYNpreferences.LBDYNcolor1.pos.x = -2660
      DYNpreferences.LBDYNcolor2.pos.x = -2660
      DYNpreferences.LBDYNcolor3.pos.x = -2660
      DYNpreferences.LBDYNcolor4.pos.x = -2660
      DYNpreferences.LBDYNcolor5.pos.x = -2660
    )
    if FUNtabIndex == 5 then
    (
      DYNpreferences.GBPREmatGeneral.pos.x    = 18
      DYNpreferences.GBPREDynSurfaces.pos.x   = 18
      DYNpreferences.GBPREimportGen.pos.x     = -2243
      DYNpreferences.GBPREimportC3D.pos.x     = -2243
      DYNpreferences.GBPREcountryKit.pos.x    = -2243
      DYNpreferences.LBPREcountryKit.pos.x    = -2227
      DYNpreferences.BUPREcountryKit.pos.x    = -2327
      DYNpreferences.GBPREprojectKit.pos.x    = -2243
      DYNpreferences.RBPREprojectKit.pos.x    = -2227
      DYNpreferences.LBPREprojectKit.pos.x    = -2227
      DYNpreferences.BUPREprojectKit.pos.x    = -2327
      DYNpreferences.GBPREprivateKit.pos.x    = -2243
      DYNpreferences.LBPREprivateKit.pos.x    = -2227
      DYNpreferences.CBPREprivateKit.pos.x    = -2227
      DYNpreferences.CBPREc3dOverHang.pos.x   = -2227
      DYNpreferences.CBPREhideDiagonals.pos.x = -2227
      DYNpreferences.BUPREprivateKit.pos.x    = -2327
      DYNpreferences.GBPREskyMapLoc.pos.x     = -2243
      DYNpreferences.GBPREanimUnits.pos.x     = -2243
      DYNpreferences.LBPREskyMapLoc.pos.x     = -2227
      DYNpreferences.BUPREskyMapLoc.pos.x     = -2327
      DYNpreferences.LBPREcountry.pos.x       = -2198
      DYNpreferences.DDPREcountry.pos.x       = -2278
      DYNpreferences.DDPREdistUnit.pos.x      = -2243
      DYNpreferences.LBPREdistUnit.pos.x      = -2243
      DYNpreferences.DDPREtimeUnit.pos.x      = -2205
      DYNpreferences.LBPREtimeUnit.pos.x      = -2205
      DYNpreferences.SPPREexplorerWidth.pos.x = -2345
      DYNpreferences.LBPREexplorerWidth.pos.x = -2198
      DYNpreferences.CBPREshowIcons.pos.x     = -2243
      DYNpreferences.CBPREdockExplorer.pos.x  = -2243
      DYNpreferences.CBPREcommandPanel.pos.x  = -2243
      DYNpreferences.CBPREresetMaxMenu.pos.x  = -2243
      DYNpreferences.CBPREdisableGrid.pos.x   = -2243
      DYNpreferences.CBPRErotateWheels.pos.x  = -2243
      DYNpreferences.LBPREshowIcons.pos.x     = -2243
      DYNpreferences.LBPREdockExplorer.pos.x  = -2243
      DYNpreferences.LBPREcommandPanel.pos.x  = -2243
      DYNpreferences.LBPREresetMaxMenu.pos.x  = -2243
      DYNpreferences.LBPREdisableGrid.pos.x   = -2243
      DYNpreferences.LBPRErotateWheels.pos.x  = -2243
      DYNpreferences.CBPREretainOPSmat.pos.x  = 27
      DYNpreferences.CBPREautoStart.pos.x     = -2198
      DYNpreferences.CBPREchainageLoop.pos.x  = -2198
      DYNpreferences.CBPREallowMultMarks.pos.x= -2198
      DYNpreferences.CBPREallowMultRails.pos.x= -2198
      DYNpreferences.LBPREautoStart.pos.x      = -2198
      DYNpreferences.LBPREchainageLoop.pos.x  = -2198
      DYNpreferences.LBPREallowMultMarks.pos.x= -2198
      DYNpreferences.LBPREallowMultRails.pos.x= -2198
      DYNpreferences.GBPREspacer01.pos.x      = -2254
      DYNpreferences.LBPREframeRate.pos.x     = -2198
      DYNpreferences.SPPREframeRate.pos.x     = -2345
      DYNpreferences.LBPREmarkerSize.pos.x    = -2198
      DYNpreferences.SPPREmarkerSize.pos.x    = -2345
      DYNpreferences.LBPREungpMatChan.pos.x   = 27
      DYNpreferences.SPPREungpMatChan.pos.x   = 464
      DYNpreferences.LBPREfaceSmoothing.pos.x = -2263
      DYNpreferences.SPPREfaceSmoothing.pos.x = -2475
      DYNpreferences.SPPREmatIDlimit.pos.x    = -2475 --464
      DYNpreferences.LBPREmatIDlimit.pos.x    = -2475 --27
      DYNpreferences.LBPREtreeVariation.pos.x = -2198
      DYNpreferences.SPPREtreeVariation.pos.x = -2345
      DYNpreferences.CODYNcolor1.pos.x = -2243
      DYNpreferences.CODYNcolor2.pos.x = -2243
      DYNpreferences.CODYNcolor3.pos.x = -2243
      DYNpreferences.CODYNcolor4.pos.x = -2243
      DYNpreferences.CODYNcolor5.pos.x = -2243
      DYNpreferences.LBDYNcolor1.pos.x = -2660
      DYNpreferences.LBDYNcolor2.pos.x = -2660
      DYNpreferences.LBDYNcolor3.pos.x = -2660
      DYNpreferences.LBDYNcolor4.pos.x = -2660
      DYNpreferences.LBDYNcolor5.pos.x = -2660
    )
    if FUNtabIndex == 6 then
    (
      DYNpreferences.GBPREmatGeneral.pos.x    = -2243
      DYNpreferences.GBPREDynSurfaces.pos.x   = -2243
      DYNpreferences.GBPREimportGen.pos.x     = 18
      DYNpreferences.GBPREimportC3D.pos.x     = 18
      DYNpreferences.GBPREcountryKit.pos.x    = -2243
      DYNpreferences.LBPREcountryKit.pos.x    = -2227
      DYNpreferences.BUPREcountryKit.pos.x    = -2327
      DYNpreferences.GBPREprojectKit.pos.x    = -2243
      DYNpreferences.RBPREprojectKit.pos.x    = -2227
      DYNpreferences.LBPREprojectKit.pos.x    = -2227
      DYNpreferences.BUPREprojectKit.pos.x    = -2327
      DYNpreferences.GBPREprivateKit.pos.x    = -2243
      DYNpreferences.LBPREprivateKit.pos.x    = -2227
      DYNpreferences.CBPREprivateKit.pos.x    = -2227
      DYNpreferences.CBPREc3dOverHang.pos.x   = 27
      DYNpreferences.CBPREhideDiagonals.pos.x = 27
      DYNpreferences.BUPREprivateKit.pos.x    = -2327
      DYNpreferences.GBPREskyMapLoc.pos.x     = -2243
      DYNpreferences.GBPREanimUnits.pos.x     = -2243
      DYNpreferences.LBPREskyMapLoc.pos.x     = -2227
      DYNpreferences.BUPREskyMapLoc.pos.x     = -2327
      DYNpreferences.LBPREcountry.pos.x       = -2198
      DYNpreferences.DDPREcountry.pos.x       = -2278
      DYNpreferences.DDPREdistUnit.pos.x      = -2243
      DYNpreferences.LBPREdistUnit.pos.x      = -2243
      DYNpreferences.DDPREtimeUnit.pos.x      = -2205
      DYNpreferences.LBPREtimeUnit.pos.x      = -2205
      DYNpreferences.SPPREexplorerWidth.pos.x = -2345
      DYNpreferences.LBPREexplorerWidth.pos.x = -2198
      DYNpreferences.CBPREshowIcons.pos.x     = -2243
      DYNpreferences.CBPREdockExplorer.pos.x  = -2243
      DYNpreferences.CBPREcommandPanel.pos.x  = -2243
      DYNpreferences.CBPREresetMaxMenu.pos.x  = -2243
      DYNpreferences.CBPREdisableGrid.pos.x   = -2243
      DYNpreferences.CBPRErotateWheels.pos.x  = -2243
      DYNpreferences.LBPREshowIcons.pos.x     = -2243
      DYNpreferences.LBPREdockExplorer.pos.x  = -2243
      DYNpreferences.LBPREcommandPanel.pos.x  = -2243
      DYNpreferences.LBPREresetMaxMenu.pos.x  = -2243
      DYNpreferences.LBPREdisableGrid.pos.x   = -2243
      DYNpreferences.LBPRErotateWheels.pos.x  = -2243
      DYNpreferences.CBPREretainOPSmat.pos.x  = -2018
      DYNpreferences.CBPREautoStart.pos.x     = -2198
      DYNpreferences.CBPREchainageLoop.pos.x  = -2198
      DYNpreferences.CBPREallowMultMarks.pos.x= -2198
      DYNpreferences.CBPREallowMultRails.pos.x= -2198
      DYNpreferences.LBPREautoStart.pos.x      = -2198
      DYNpreferences.LBPREchainageLoop.pos.x  = -2198
      DYNpreferences.LBPREallowMultMarks.pos.x= -2198
      DYNpreferences.LBPREallowMultRails.pos.x= -2198
      DYNpreferences.GBPREspacer01.pos.x      = -2189
      DYNpreferences.LBPREframeRate.pos.x     = -2198
      DYNpreferences.SPPREframeRate.pos.x     = -2345
      DYNpreferences.LBPREmarkerSize.pos.x    = -2198
      DYNpreferences.SPPREmarkerSize.pos.x    = -2345
      DYNpreferences.LBPREungpMatChan.pos.x   = -2198
      DYNpreferences.SPPREungpMatChan.pos.x   = -2345
      DYNpreferences.LBPREfaceSmoothing.pos.x = 27
      DYNpreferences.SPPREfaceSmoothing.pos.x = 464
      DYNpreferences.SPPREmatIDlimit.pos.x    = -2475
      DYNpreferences.LBPREmatIDlimit.pos.x    = -2475
      DYNpreferences.LBPREtreeVariation.pos.x = -2198
      DYNpreferences.SPPREtreeVariation.pos.x = -2345
      DYNpreferences.CODYNcolor1.pos.x = -2243
      DYNpreferences.CODYNcolor2.pos.x = -2243
      DYNpreferences.CODYNcolor3.pos.x = -2243
      DYNpreferences.CODYNcolor4.pos.x = -2243
      DYNpreferences.CODYNcolor5.pos.x = -2243
      DYNpreferences.LBDYNcolor1.pos.x = -2660
      DYNpreferences.LBDYNcolor2.pos.x = -2660
      DYNpreferences.LBDYNcolor3.pos.x = -2660
      DYNpreferences.LBDYNcolor4.pos.x = -2660
      DYNpreferences.LBDYNcolor5.pos.x = -2660
    )

  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  groupBox GBDYNtab pos:[6,25] width:490 height:237
  dotNetControl dnTabCtrl "System.Windows.Forms.TabControl" height:23 width:490 pos:[6,9]

  --Tab 1 Controls
  checkbox CBPREautoStart      pos:[2018,41]  height:30 width:16
  checkbox CBPREshowIcons      pos:[2018,78]  height:30 width:16
  checkbox CBPREdockExplorer   pos:[2018,115] height:30 width:16
  checkbox CBPREcommandPanel   pos:[2018,152] height:30 width:16  checked:true
  checkbox CBPREresetMaxMenu   pos:[2018,189] height:30 width:16
  checkbox CBPREdisableGrid    pos:[2018,226] height:30 width:16

  label LBPREautoStart         pos:[2018,41]  height:30 width:210
  label LBPREshowIcons         pos:[2018,78]  height:30 width:210
  label LBPREdockExplorer      pos:[2018,115] height:30 width:210
  label LBPREcommandPanel      pos:[2018,152] height:30 width:210
  label LBPREresetMaxMenu      pos:[2018,189] height:30 width:210
  label LBPREdisableGrid       pos:[2018,226] height:30 width:210

  checkbox CBPRErotateWheels   pos:[2340,123] height:20 width:16
  checkbox CBPREchainageLoop   pos:[2340,150] height:30 width:16
  checkbox CBPREallowMultMarks pos:[2340,188] height:30 width:16
  checkbox CBPREallowMultRails pos:[2340,226] height:30 width:16
  label LBPRErotateWheels      pos:[2360,125] height:20 width:200
  label LBPREchainageLoop      pos:[2360,150] height:30 width:200
  label LBPREallowMultMarks    pos:[2360,188] height:30 width:200
  label LBPREallowMultRails    pos:[2360,226] height:30 width:200

  groupBox GBPREspacer01       pos:[2189,40]  height:213 width:1
  spinner SPPREframeRate     pos:[2345,39]  type:#integer range:[10,40,30]     fieldwidth:40 align:#left
  spinner SPPREmarkerSize    pos:[2345,59]  type:#integer range:[1,25,5]       fieldwidth:40 align:#left
  spinner SPPREexplorerWidth   pos:[2345,79]  type:#integer range:[208,300,208] fieldwidth:40 align:#left
  spinner SPPREtreeVariation pos:[2345,99]  type:#integer range:[1,40,15]      fieldwidth:40 align:#left

  label LBPREframeRate       pos:[2198,41]  width:175 align:#left
  label LBPREmarkerSize      pos:[2198,61]  width:175 align:#left
  label LBPREexplorerWidth   pos:[2198,81]  width:175 align:#left
  label LBPREtreeVariation   pos:[2198,101] width:175 align:#left

  --Tab 2 Controls
  groupBox GBPREskyMapLoc pos:[2018,40] width:466 height:37
  label  LBPREskyMapLoc pos:[2027,57] width:450 align:#left
  button BUPREskyMapLoc "..." pos:[2457,52] width:20 height:20

  groupBox GBPREanimUnits pos:[2018,85] width:220 height:115

  label  LBPREdistUnit         pos:[2028,105] width:195
  label  LBPREtimeUnit         pos:[2028,149] width:195

  dropdownlist DDPREdistUnit   pos:[2028,121] width:198
  dropdownlist DDPREtimeUnit   pos:[2028,165] width:198

    --Tab 3 Controls
  colorpicker CODYNcolor1 fieldwidth:30 height:20 pos:[2018,45] color:DYNINIhighlightColor
  colorpicker CODYNcolor2 fieldwidth:30 height:20 pos:[2018,75] color:DYNINIgreyedOutColor
  colorpicker CODYNcolor3 fieldwidth:30 height:20 pos:[2018,105] color:DYNINIstartMarkerColor
  colorpicker CODYNcolor4 fieldwidth:30 height:20 pos:[2018,135] color:DYNINIendMarkerColor
  colorpicker CODYNcolor5 fieldwidth:30 height:20 pos:[2018,165] color:DYNINImarkingColor
  label LBDYNcolor1 width:330 align:#left pos:[2060,48]
  label LBDYNcolor2 width:330 align:#left pos:[2060,78]
  label LBDYNcolor3 width:330 align:#left pos:[2060,108]
  label LBDYNcolor4 width:330 align:#left pos:[2060,138]
  label LBDYNcolor5 width:330 align:#left pos:[2060,168]

  --Tab 4 Controls
  groupBox GBPREcountryKit pos:[2018,40] width:466 height:62
  label  LBPREcountryKit pos:[2027,57] width:450 align:#left
  button BUPREcountryKit "..." pos:[2457,52] width:20 height:20
  label  LBPREcountry   width:165 pos:[2018,80]
  dropdownlist DDPREcountry   width:200 pos:[2278,76]

  groupBox GBPREprojectKit pos:[2018,107] width:466 height:82
  radioButtons RBPREprojectKit  pos:[2027,123] width:205 align:#left labels:#(DYNuiResourcesPreferences[51], DYNuiResourcesPreferences[52], DYNuiResourcesPreferences[53]) columns:1
  label  LBPREprojectKit pos:[2027,170] width:450 align:#left
  button BUPREprojectKit "..." pos:[2327,164] width:20 height:20

  groupBox GBPREprivateKit pos:[2018,194] width:466 height:57
  checkbox CBPREprivateKit pos:[2027,211] width:450 align:#left
  label  LBPREprivateKit pos:[2027,231] width:450 align:#left
  button BUPREprivateKit "..." pos:[2457,226] width:20 height:20

  -- Tab 5 Controls
  groupBox GBPREDynSurfaces pos:[2018,40] width:466 height:40
  spinner SPPREungpMatChan pos:[2345,57]  type:#integer range:[1,999,1]   fieldwidth:40 align:#left
  label LBPREungpMatChan   pos:[2198,59]  width:350 align:#left

  groupBox GBPREmatGeneral pos:[2018,178] width:466 height:73
  checkbox CBPREretainOPSmat pos:[2018,195]  height:18 width:420

  spinner SPPREmatIDlimit  pos:[2345,227]  type:#integer range:[99,999,99] fieldwidth:40 align:#left
  label LBPREmatIDlimit    pos:[2198,229]  width:350 align:#left

  -- Tab 6 Controls
  groupBox GBPREimportGen pos:[2018,40] width:466 height:40
  spinner SPPREfaceSmoothing pos:[2345,57]  range:[0.0,180.0,10.0] type:#float scale:0.1 fieldwidth:50 align:#left
  label LBPREfaceSmoothing   pos:[2198,59]  width:350 align:#left

  groupBox GBPREimportC3D pos:[2018,86] width:466 height:67
  checkbox CBPREc3dOverHang pos:[2027,106] width:450 align:#left
  checkbox CBPREhideDiagonals pos:[2027,126] width:450 align:#left

  button BUDYNhelp " " width:80 height:22 pos:[6,272]
  button BUDYNokok " " width:80 height:22 pos:[334,272]
  button BUDYNcanc " " width:80 height:22 pos:[416,272]

  dotNetControl  dnProgress "System.Windows.Forms.ProgressBar" width:490 height:14 pos:[6,302]
  label LBDYNstatus pos:[6,321] width:490 height:18



  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on dynpreferences open do
  (
    clearSelection()
    DYNpreferences.title     = DYNuiResourcesPreferences[2]
    GBPREskyMapLoc.text      = DYNuiResourcesPreferences[10]
    GBPREanimUnits.text      = DYNuiResourcesPreferences[11]
    GBPREcountryKit.text     = DYNuiResourcesPreferences[12]
    GBPREprojectKit.text     = DYNuiResourcesPreferences[13]
    GBPREprivateKit.text     = DYNuiResourcesPreferences[14]
    GBPREDynSurfaces.text    = DYNuiResourcesPreferences[15]
    GBPREmatGeneral.text     = DYNuiResourcesPreferences[16]
    GBPREimportGen.text      = DYNuiResourcesPreferences[17]
    GBPREimportC3D.text      = DYNuiResourcesPreferences[18]
    BUDYNokok.text           = DYNuiResourcesButtons[1]
    BUDYNcanc.text           = DYNuiResourcesButtons[3]
    BUDYNhelp.text           = DYNuiResourcesButtons[5]
    LBDYNstatus.text         = DYNuiResourcesPreferences[1]
    LBDYNcolor1.text         = DYNuiResourcesPreferences[22]
    LBDYNcolor2.text         = DYNuiResourcesPreferences[23]
    LBDYNcolor3.text         = DYNuiResourcesPreferences[24]
    LBDYNcolor4.text         = DYNuiResourcesPreferences[25]
    LBDYNcolor5.text         = DYNuiResourcesPreferences[28]
    LBPREcountry.text        = DYNuiResourcesPreferences[40]
    LBPREdistUnit.text       = DYNuiResourcesPreferences[41]
    LBPREtimeUnit.text       = DYNuiResourcesPreferences[42]
    LBPREfaceSmoothing.text  = DYNuiResourcesPreferences[43]
    CBPREc3dOverHang.text    = DYNuiResourcesPreferences[44]
    CBPREhideDiagonals.text  = DYNuiResourcesPreferences[45]
    CBPREprivateKit.text     = DYNuiResourcesPreferences[54]
    LBPREshowIcons.text      = DYNuiResourcesPreferences[35]
    LBPREdockExplorer.text   = DYNuiResourcesPreferences[21]
    LBPREcommandPanel.text   = DYNuiResourcesPreferences[30]
    LBPREresetMaxMenu.text   = DYNuiResourcesPreferences[31]
    LBPREdisableGrid.text    = DYNuiResourcesPreferences[32]
    LBPRErotateWheels.text   = DYNuiResourcesPreferences[55]
    CBPREretainOPSmat.text   = DYNuiResourcesPreferences[46]
    LBPREautoStart.text      = DYNuiResourcesPreferences[47]
    LBPREchainageLoop.text   = DYNuiResourcesPreferences[27]
    LBPREallowMultMarks.text = DYNuiResourcesPreferences[48]
    LBPREallowMultRails.text = DYNuiResourcesPreferences[49]
    LBPREframeRate.text      = DYNuiResourcesPreferences[20]
    SPPREframeRate.value     = DYNINIframeRate
    LBPREmarkerSize.text     = DYNuiResourcesPreferences[26]
    SPPREmarkerSize.value    = DYNINImarkerSize
    LBPREungpMatChan.text    = DYNuiResourcesPreferences[33]
    LBPREmatIDlimit.text     = DYNuiResourcesPreferences[50]
    SPPREungpMatChan.value   = DYNINIungpMatChan
    SPPREmatIDlimit.value    = DYNINImatIDlimit

    LBPREtreeVariation.text  = DYNuiResourcesPreferences[34]
    SPPREtreeVariation.value = DYNINItreeVariation
    SPPREfaceSmoothing.value = DYNINIfaceSmoothing

    LBPREexplorerWidth.text  = DYNuiResourcesPreferences[29]
    SPPREexplorerWidth.value = DYNINIexplorerWidth

    /* Set Up Drop Down List Items */
    DDPREcountry.items     = DYNFUNgetCountryKits DYNcountryRootPath                          -- Get Array of Country Kits Available on System
    DDPREdistUnit.items    = DYNuiResourcesUnitsDistance
    DDPREtimeUnit.items    = DYNuiResourcesUnitsTime
    LBPREcountryKit.text   = DYNFUNtrimPathName DYNcountryRootPath 450
    LBPREskyMapLoc.text    = DYNFUNtrimPathName DYNskyMapPath 450

    /*  Set Up Drop Down List Selections */
    if DYNINIcountry   != undefined then DDPREcountry.selection   = findItem DDPREcountry.items (DYNFUNupperCase DYNINIcountry 0)

    if (classof DYNINIspeedValue) == Point2 then
    (
      DDPREdistUnit.selection = DYNINIspeedValue.x as integer
      DDPREtimeUnit.selection = DYNINIspeedValue.y as integer
    )
    else
    (
      DDPREdistUnit.enabled = false
      DDPREtimeUnit.enabled = false
    )

    /* Set up Check Boxes */
    CBPREshowIcons.checked      = DYNINIshowIcons
    CBPREretainOPSmat.checked   = DYNINIretainOPSmat
    CBPREallowMultMarks.checked = DYNINIallowMultMarks
    CBPREallowMultRails.checked = DYNINIallowMultRails
    CBPREcommandPanel.checked   = if DYNINIcomPanel           == "1" then true else false
    CBPREresetMaxMenu.checked   = if DYNINIresetMaxMenu       == "1" then true else false
    CBPREdisableGrid.checked    = if DYNINIdisableGrid        == "1" then true else false
    CBPREc3doverHang.checked    = if DYNINIoverhangCorrect    == "1" then true else false
    CBPREhideDiagonals.checked  = if DYNINIhideDiagonals      == "1" then true else false
    CBPREautoStart.checked      = if DYNINIautoStart          == "1" then true else false
    CBPREchainageLoop.checked   = if DYNINIchainageLoop       == "1" then true else false

    LOCprivateKitPath           = DYNINIprivateKitPath
    LBPREprivateKit.text        = DYNFUNtrimPathName DYNINIprivateKitPath 450
    CBPREprivateKit.checked     = if DYNINIprivateKit         == "1" then true else false
    LBPREprivateKit.enabled = BUPREprivateKit.enabled = CBPREprivateKit.checked

    LOCprojectKitPath           = DYNINIprojectKitPath
    LBPREprojectKit.text        = DYNFUNtrimPathName DYNINIprojectKitPath 450
    RBPREprojectKit.state       = if DYNINIprojectKit == "0" or DYNINIprojectKit != "0" or DYNINIprojectKit == "2" then ((DYNINIprojectKit as integer) + 1) else 1
    LBPREprojectKit.enabled = BUPREprojectKit.enabled = DYNINIprojectKit == "2"

    CBPRErotateWheels.checked   = if DYNINIrotateWheels       == "1" then true else false
    CBPREdockExplorer.checked   = if DYNINIdockExplorer       == "1" then true else false

    --- Other things
    LOCtabLabels = #(DYNuiResourcesPreferences[4], DYNuiResourcesPreferences[5], DYNuiResourcesPreferences[6], DYNuiResourcesPreferences[7], DYNuiResourcesPreferences[8], DYNuiResourcesPreferences[9])
    for i = 1 to LOCtabLabels.count do (dntabctrl.tabpages.add LOCtabLabels[i])
    dnTabCtrl.alignment = DYNdnTabAlignClass.top
  )

  on dynpreferences close do
  (
    DYNFUNonDialogClose()
  )

  on dnTabCtrl mouseUp arg do
  (
    DYNFUNmoveControls (dnTabCtrl.selectedTab.TabIndex + 1)
  )

  on CBPREprivateKit changed arg do
  (
    LBPREprivateKit.enabled = arg
    BUPREprivateKit.enabled = arg
    if arg then LOCprivateKitPathChanged = true
  )

  on RBPREprojectKit changed arg do
  (
    LBPREprojectKit.enabled = if arg == 3 then true else false
    BUPREprojectKit.enabled = if arg == 3 then true else false
  )

  on BUDYNokok pressed do
  (
    LBDYNstatus.text = DYNuiResourcesStatusMessages[1]

    --- Resize Explorer Panel If Width Was Changed
    if SPPREexplorerWidth.value != DYNINIexplorerWidth then
    (
      DYNINIexplorerWidth = SPPREexplorerWidth.value


      if DYNmainFloater != undefined then
      (
        /* Close Explorer Panel if it is currently open */
        try (if DYNmainFloater.dialogBar then cui.UnRegisterDialogBar DYNmainFloater) catch () -- Unregister Dockable State of Dynamite Explorer Rollout FLoater
        closerolloutfloater DYNmainFloater; DYNmainFloater = undefined -- Close and Reset Rollout Floater if it exists

        /* Re-open Explorer Panel if it was open using new width value */
        DYNFUNopenExplorer()
      )
    )

    --- Find out whether scene frame rate should be updated or just INI file defualt setting
    if frameRate != SPPREframeRate.value then
    (
      if querybox DYNuiResourcesPreferences[3] title:DYNuiResourcesTitlebars[2] then
      (
        frameRate = SPPREframeRate.value
      )
    )

    --- Copy new values to INI file
    dnProgress.value  = 10
    local LOCcomPanel       = if CBPREcommandPanel.checked   == true then "1" else "0"
    local LOCresetMaxMenu   = if CBPREresetMaxMenu.checked   == true then "1" else "0"
    local LOCdisableGrid    = if CBPREdisableGrid.checked    == true then "1" else "0"
    local LOCoverhangCorrect= if CBPREc3dOverHang.checked    == true then "1" else "0"
    local LOChideDiagonals  = if CBPREhideDiagonals.checked  == true then "1" else "0"
    local LOCshadowSaver    = "0"
    local LOCautoStart      = if CBPREautoStart.checked      == true then "1" else "0"
    local LOCchainageLoop   = if CBPREchainageLoop.checked   == true then "1" else "0"
    local LOCprivateKit     = if CBPREprivateKit.checked     == true then "1" else "0"
    local LOCprojectKit     = (RBPREprojectKit.state - 1) as string
    local LOCretainOPSmat   = if CBPREretainOPSmat.checked   == true then "1" else "0"
    local LOCallowMultMarks = if CBPREallowMultMarks.checked == true then "1" else "0"
    local LOCallowMultRails = if CBPREallowMultRails.checked == true then "1" else "0"
    local LOCenableFog      = "0"
    local LOCrotateWheels   = if CBPRErotateWheels.checked   == true then "1" else "0"
    local LOCdockExplorer   = if CBPREdockExplorer.checked   == true then "1" else "0"
    local LOCshowIcons      = if CBPREshowIcons.checked      == true then "1" else "0"

    setINISetting DYNmainINI "VSP Colors"   "HighlightColor"     (CODYNcolor1.color as string); dnProgress.value = 15
    setINISetting DYNmainINI "VSP Colors"   "GreyedOutColor"     (CODYNcolor2.color as string); dnProgress.value = 20
    setINISetting DYNmainINI "VSP Colors"   "StartMarkerColor"   (CODYNcolor3.color as string); dnProgress.value = 23
    setINISetting DYNmainINI "VSP Colors"   "EndMarkerColor"     (CODYNcolor4.color as string); dnProgress.value = 25
    setINISetting DYNmainINI "VSP Colors"   "RoadMarkingColor"   (CODYNcolor5.color as string); dnProgress.value = 27

    setINISetting DYNmainINI "General Settings" "3dsComPanel"        (LOCcomPanel)
    setINISetting DYNmainINI "General Settings" "ExplorerWidth"      (SPPREexplorerWidth.value as string)
    setINISetting DYNmainINI "General Settings" "Distance"           (DDPREdistUnit.selection as string)
    setINISetting DYNmainINI "General Settings" "Time"               (DDPREtimeUnit.selection as string)
    setINISetting DYNmainINI "General Settings" "FrameRate"          (SPPREframeRate.value as string)
    setINISetting DYNmainINI "General Settings" "MarkerSize"         (SPPREmarkerSize.value as string)
    setINISetting DYNmainINI "General Settings" "DefaultMatChannel"  (SPPREungpMatChan.value as string)
    setINISetting DYNmainINI "General Settings" "MatIDlimit"         (SPPREmatIDlimit.value as string)
    setINISetting DYNmainINI "General Settings" "ResetMaxMenu"       (LOCresetMaxMenu)
    setINISetting DYNmainINI "General Settings" "DisableGrid"        (LOCdisableGrid)
    setINISetting DYNmainINI "General Settings" "OverhangCorrect"    (LOCoverhangCorrect)
    setINISetting DYNmainINI "General Settings" "HideDiagonals"      (LOChideDiagonals)
    setINISetting DYNmainINI "General Settings" "ShadowSaver"        (LOCshadowSaver)
    setINISetting DYNmainINI "General Settings" "ChainageLoop"       (LOCchainageLoop)
    setINISetting DYNmainINI "General Settings" "retainOPSmat"       (LOCretainOPSmat)
    setINISetting DYNmainINI "General Settings" "allowMultMarks"     (LOCallowMultMarks)
    setINISetting DYNmainINI "General Settings" "allowMultRails"     (LOCallowMultRails)
    setINISetting DYNmainINI "General Settings" "EnableFog"          (LOCenableFog)
    setINISetting DYNmainINI "General Settings" "RotateWheels"       (LOCrotateWheels)
    setINISetting DYNmainINI "General Settings" "DockExplorer"       (LOCdockExplorer)
    setINISetting DYNmainINI "General Settings" "ShowIcons"          (LOCshowIcons)
    setINISetting DYNmainINI "General Settings" "TreeVariation"      (SPPREtreeVariation.value as string)
    setINISetting DYNmainINI "General Settings" "FaceSmoothing"      (SPPREfaceSmoothing.value as string)

    setINISetting DYNmainINI "General Settings" "ProjectKit"         (LOCprojectKit)
    setINISetting DYNmainINI "General Settings" "ProjectKitPath"     (LOCprojectKitPath)

    setINISetting DYNmainINI (sysInfo.userName) "PrivateKit"     (LOCprivateKit)
    setINISetting DYNmainINI (sysInfo.userName) "PrivateKitPath" (LOCprivateKitPath)
    setINISetting DYNmainINI (sysInfo.userName) "AutoStart"      (LOCautoStart)

    DYNFUNdynamiteInitialise DYNuiResourcesStatusMessages[1] DYNINIcountry SPPREexplorerWidth.value DYNsplashPanel.LBDYNlabel01 CODYNcolor1.color CODYNcolor2.color CODYNcolor3.color CODYNcolor4.color SPPREframeRate.value SPPREmarkerSize.value LOCcomPanel [DDPREdistUnit.selection,DDPREtimeUnit.selection] SPPREtreeVariation.value LOCresetMaxMenu LOCdisableGrid SPPREungpMatChan.value CODYNcolor5.color LOCdockExplorer CBPREshowIcons.checked LOCenableFog LOCchainageLoop CBPREretainOPSmat.checked CBPREallowMultMarks.checked CBPREallowMultRails.checked LOCshadowSaver LOCprivateKit LOCprojectKit LOCprivateKitPath LOCprojectKitPath LOCoverhangCorrect LOChideDiagonals SPPREfaceSmoothing.value SPPREmatIDlimit.value LOCautoStart LOCrotateWheels DYNcountryRootPath

    dnProgress.value = 100

    --- Following Settings Should Only Take Effect Next Time Civil View is Started, so don't update global variables directly, just Update INI File
    setINISetting DYNmainINI "General Settings" "Country"  (DDPREcountry.selected)

    if LOCcountryRootPathChanged and LOCcountryRootPath != undefined then
    (
      setINIsetting DYNmainINI "General Settings" "CountryRootPath" LOCcountryRootPath
    )

    if LOCskyMapPathChanged and LOCskyMapPath != undefined then
    (
      setINIsetting DYNmainINI "General Settings" "SkyMapPath" LOCskyMapPath
    )

    if LOCprojectKitPathChanged and LOCprojectKitPath != "" then
    (
    )

    if LOCprivateKitPathChanged and LOCprivateKitPath != "" then
    (
      if not (DYNFUNmakeResourceKitStructure (getfilenamepath LOCprivateKitPath) (getfilenamefile LOCprivateKitPath)) then
      (
        messagebox DYNuiResourcesErrorsWarnings[8] title:DYNuiResourcesTitlebars[1]
      )
    )

    --- Finish Routine
    DYNFUNrebuildExplorerTreeNodes DYNuiResourcesObjClasses DYNuiResourcesCvExplorer-- For language adjustments!!
    DYNFUNnodeCreatedCallback()
    LBDYNstatus.text = ""
    destroyDialog DYNpreferences
  )

  on BUPREprivateKit pressed do
  (
    local LOCckPath = getSavePath caption:DYNuiResourcesPreferences[39]
    if LOCckPath != undefined then
    (
      LOCprivateKitPathChanged  = true
      LOCprivateKitPath         = LOCckPath
      LBPREprivateKit.text      = DYNFUNtrimPathName LOCckPath 450
    )
  )

  on BUPREprojectKit pressed do
  (
    local LOCckPath = getSavePath caption:DYNuiResourcesPreferences[38]
    if LOCckPath != undefined then
    (
      LOCprojectKitPathChanged  = true
      LOCprojectKitPath         = LOCckPath
      LBPREprojectKit.text      = DYNFUNtrimPathName LOCckPath 450
    )
  )

  on BUPREcountryKit pressed do
  (
    local LOCckPath = getSavePath caption:DYNuiResourcesPreferences[37]
    if LOCckPath != undefined then
    (
      local LOCcountryArray = DYNFUNgetCountryKits LOCckPath
      if LOCcountryArray.count > 0 then
      (
        LOCcountryRootPathChanged = true
        LOCcountryRootPath        = LOCckPath
        LBPREcountryKit.text      = DYNFUNtrimPathName LOCckPath 450
        DDPREcountry.items        = LOCcountryArray
        DDPREcountry.selection    = 1
      )
      else
      (
        messageBox DYNuiResourcesErrorsWarnings[7] title:DYNuiResourcesTitlebars[1]
      )
    )
  )

  on BUPREskyMapLoc pressed do
  (
    local LOCskyPath = getSavePath caption:DYNuiResourcesPreferences[36]
    if LOCskyPath != undefined then
    (
      local LOCimageArray = DYNFUNlistLibraryMaps (LOCskyPath + "\\")
      if LOCimageArray.count > 0 then
      (
        LOCskyMapPathChanged      = true
        LOCskyMapPath             = LOCskyPath
        LBPREskyMapLoc.text       = DYNFUNtrimPathName LOCskyPath 450
        messagebox DYNuiResourcesErrorsWarnings[5] title:DYNuiResourcesTitlebars[3] beep:false
      )
      else
      (
        messageBox DYNuiResourcesErrorsWarnings[6] title:DYNuiResourcesTitlebars[1]
      )
    )
  )

  on BUDYNcanc pressed do destroyDialog DYNpreferences

  on BUDYNhelp pressed do DYNFUNopenHelp 13213 -- id_cv_preferences
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQClSYbICj6eqHd59HyaUvgYOyNBxI2fBDVE
-- iSBfb8o+7Lzo51hh/qj+Ny7T5Dq5n09+zEsYXJ3CG/W2vtL46D4OsVjkn+sJUYpe
-- GKzTEAqqXb+aNF9dgK3HaPbdI1lP3ljmM8VK8HE7HwewJuKoqzkalX7GhOtZ+CEo
-- Fa2O1InuQ29116vdc6iJa25TE2hH8U83pjw5nbk8DbdGAoEH29so7SbWHX6cjRJD
-- agc33biF5T0vgT21oUPJdMAbXaagIMXEad+NKS+hRxXRug5L11JYU7QNyuxKgcwd
-- IwQdf8UYRKBeo4JwiOYfJsY+JFgY7lOboDnkFwnkAt6a1SM6vsHs
-- -----END-SIGNATURE-----